/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.profess.ClassOption;
import net.Indyuce.mmocore.api.player.profess.PlayerClass;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.manager.InventoryManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ClassSelect
extends EditableInventory {
    public ClassSelect() {
        super("class-select");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        return function.startsWith("class") ? new ClassItem(config) : new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return this.newInventory(data, null);
    }

    public GeneratedInventory newInventory(PlayerData data, @Nullable Runnable profileRunnable) {
        return new ProfessSelectionInventory(data, this, profileRunnable);
    }

    private PlayerClass findDeepestSubclass(PlayerData player, PlayerClass root) {
        for (String checkedName : player.getSavedClasses()) {
            PlayerClass checked = MMOCore.plugin.classManager.getOrThrow(checkedName);
            if (!root.hasSubclass(checked)) continue;
            return checked;
        }
        return root;
    }

    public class ClassItem
    extends SimplePlaceholderItem<ProfessSelectionInventory> {
        private final String name;
        private final List<String> lore;
        private final PlayerClass playerClass;

        public ClassItem(ConfigurationSection config) {
            super(config.contains("item") ? Material.valueOf((String)UtilityMethods.enumName((String)config.getString("item"))) : Material.BARRIER, config);
            Validate.isTrue((config.getString("function").length() > 6 ? 1 : 0) != 0, (String)("Couldn't find the class associated to: " + config.getString("function")));
            String classId = UtilityMethods.enumName((String)config.getString("function").substring(6));
            this.playerClass = MMOCore.plugin.classManager.getOrThrow(classId);
            this.name = config.getString("name");
            this.lore = config.getStringList("lore");
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(ProfessSelectionInventory inv, int n) {
            int j;
            ItemStack item = n == 0 ? this.playerClass.getIcon() : super.display(inv, n);
            ItemMeta meta = item.getItemMeta();
            if (this.hideFlags()) {
                MMOCoreUtils.addAllItemFlags(meta);
            }
            if (this.hideTooltip()) {
                meta.setHideTooltip(true);
            }
            meta.setDisplayName(MythicLib.plugin.parseColors(this.name).replace("{name}", this.playerClass.getName()));
            ArrayList<String> lore = new ArrayList<String>(this.lore);
            int index = lore.indexOf("{lore}");
            if (index >= 0) {
                lore.remove(index);
                for (j = 0; j < this.playerClass.getDescription().size(); ++j) {
                    lore.add(index + j, this.playerClass.getDescription().get(j));
                }
            }
            if ((index = lore.indexOf("{attribute-lore}")) >= 0) {
                lore.remove(index);
                for (j = 0; j < this.playerClass.getAttributeDescription().size(); ++j) {
                    lore.add(index + j, this.playerClass.getAttributeDescription().get(j));
                }
            }
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)MMOCore.plugin, "class_id"), PersistentDataType.STRING, (Object)this.playerClass.getId());
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }
    }

    public class ProfessSelectionInventory
    extends GeneratedInventory {
        @Nullable
        private final Runnable profileRunnable;
        private boolean canClose;

        public ProfessSelectionInventory(PlayerData playerData, @Nullable EditableInventory editable, Runnable profileRunnable) {
            super(playerData, editable);
            this.profileRunnable = profileRunnable;
        }

        @Override
        public String calculateName() {
            return ClassSelect.this.getName();
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item instanceof ClassItem) {
                PlayerClass profess = ((ClassItem)item).playerClass;
                if (this.profileRunnable == null && this.playerData.getClassPoints() < 1) {
                    MMOCore.plugin.soundManager.getSound(SoundEvent.CANT_SELECT_CLASS).playTo(this.player);
                    ConfigMessage.fromKey("cant-choose-new-class", new Object[0]).send(this.player);
                    return;
                }
                if (profess.hasOption(ClassOption.NEEDS_PERMISSION) && !this.player.hasPermission("mmocore.class." + profess.getId().toLowerCase())) {
                    MMOCore.plugin.soundManager.getSound(SoundEvent.CANT_SELECT_CLASS).playTo(this.player);
                    ConfigMessage.fromKey("no-permission-for-class", new Object[0]).send(this.player);
                    return;
                }
                if (profess.equals(this.playerData.getProfess())) {
                    MMOCore.plugin.soundManager.getSound(SoundEvent.CANT_SELECT_CLASS).playTo(this.player);
                    ConfigMessage.fromKey("already-on-class", "class", profess.getName()).send(this.player);
                    return;
                }
                this.canClose = true;
                PlayerClass playerClass = ClassSelect.this.findDeepestSubclass(this.playerData, profess);
                InventoryManager.CLASS_CONFIRM.get(MMOCoreUtils.ymlName(playerClass.getId())).newInventory(this.playerData, this, this.profileRunnable != null, this.profileRunnable).open();
            }
        }

        @Override
        public void open() {
            this.canClose = false;
            super.open();
        }

        @Override
        public void whenClosed(InventoryCloseEvent event) {
            if (this.profileRunnable != null && !this.canClose) {
                Bukkit.getScheduler().runTaskLater((Plugin)MMOCore.plugin, () -> this.open(), 40L);
            }
        }
    }
}

