/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import io.lumine.mythic.lib.manager.StatManager;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.event.PlayerAttributeUseEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttribute;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttributes;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;

public class AttributeView
extends EditableInventory {
    public AttributeView() {
        super("attribute-view");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equalsIgnoreCase("reallocation")) {
            return new InventoryItem(config){

                public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    holders.register("attribute_points", inv.getPlayerData().getAttributePoints());
                    holders.register("points", inv.getPlayerData().getAttributeReallocationPoints());
                    holders.register("total", inv.getPlayerData().getAttributes().countPoints());
                    return holders;
                }
            };
        }
        return function.startsWith("attribute_") ? new AttributeItem(function, config) : new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new AttributeViewerInventory(data, this);
    }

    public static class AttributeItem
    extends InventoryItem {
        private final PlayerAttribute attribute;
        private final int shiftCost;

        public AttributeItem(String function, ConfigurationSection config) {
            super(config);
            this.attribute = MMOCore.plugin.attributeManager.get(function.substring("attribute_".length()).toLowerCase().replace(" ", "-").replace("_", "-"));
            this.shiftCost = Math.max(config.getInt("shift-cost"), 1);
        }

        public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
            int total = inv.getPlayerData().getAttributes().getInstance(this.attribute).getTotal();
            Placeholders holders = new Placeholders();
            holders.register("name", this.attribute.getName());
            holders.register("buffs", this.attribute.getBuffs().size());
            holders.register("spent", inv.getPlayerData().getAttributes().getInstance(this.attribute).getBase());
            holders.register("max", this.attribute.getMax());
            holders.register("current", total);
            holders.register("attribute_points", inv.getPlayerData().getAttributePoints());
            holders.register("shift_points", this.shiftCost);
            this.attribute.getBuffs().forEach(buff -> {
                String stat = buff.getStat();
                holders.register("buff_" + buff.getStat().toLowerCase(), StatManager.format((String)stat, (double)buff.getValue()));
                holders.register("total_" + buff.getStat().toLowerCase(), StatManager.format((String)stat, (double)buff.multiply((double)total).getValue()));
            });
            return holders;
        }
    }

    public class AttributeViewerInventory
    extends GeneratedInventory {
        public AttributeViewerInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
        }

        @Override
        public String calculateName() {
            return AttributeView.this.getName();
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equalsIgnoreCase("reallocation")) {
                int spent = this.playerData.getAttributes().countPoints();
                if (spent < 1) {
                    ConfigMessage.fromKey("no-attribute-points-spent", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                if (this.playerData.getAttributeReallocationPoints() < 1) {
                    ConfigMessage.fromKey("not-attribute-reallocation-point", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                this.playerData.getAttributes().getInstances().forEach(ins -> ins.setBase(0));
                this.playerData.giveAttributePoints(spent);
                this.playerData.giveAttributeReallocationPoints(-1);
                ConfigMessage.fromKey("attribute-points-reallocated", "points", String.valueOf(this.playerData.getAttributePoints())).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.RESET_ATTRIBUTES).playTo(this.getPlayer());
                this.open();
            }
            if (item.getFunction().startsWith("attribute_")) {
                int pointsSpent;
                PlayerAttribute attribute = ((AttributeItem)item).attribute;
                if (this.playerData.getAttributePoints() < 1) {
                    ConfigMessage.fromKey("not-attribute-point", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                PlayerAttributes.AttributeInstance ins2 = this.playerData.getAttributes().getInstance(attribute);
                if (attribute.hasMax() && ins2.getBase() >= attribute.getMax()) {
                    ConfigMessage.fromKey("attribute-max-points-hit", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                boolean shiftClick = context.getClickType().isShiftClick();
                int n = pointsSpent = shiftClick ? ((AttributeItem)item).shiftCost : 1;
                if (attribute.hasMax()) {
                    pointsSpent = Math.min(pointsSpent, attribute.getMax() - ins2.getBase());
                }
                if (shiftClick && this.playerData.getAttributePoints() < pointsSpent) {
                    ConfigMessage.fromKey("not-attribute-point-shift", "shift_points", String.valueOf(pointsSpent)).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                ins2.addBase(pointsSpent);
                this.playerData.giveAttributePoints(-pointsSpent);
                while (pointsSpent-- > 0) {
                    attribute.updateAdvancement(this.playerData, ins2.getBase());
                }
                ConfigMessage.fromKey("attribute-level-up", "attribute", attribute.getName(), "level", String.valueOf(ins2.getBase())).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.LEVEL_ATTRIBUTE).playTo(this.getPlayer());
                PlayerAttributeUseEvent playerAttributeUseEvent = new PlayerAttributeUseEvent(this.playerData, attribute);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerAttributeUseEvent);
                this.open();
            }
        }
    }
}

