/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ExpCurve {
    private final String id;
    private final List<Integer> experience = new ArrayList<Integer>();
    public static final ExpCurve DEFAULT = new ExpCurve("default", 100, 200, 300, 400, 500);

    public ExpCurve(File file) {
        this.id = file.getName().replace(".txt", "").toLowerCase().replace("_", "-").replace(" ", "-");
        try {
            String readLine;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((readLine = reader.readLine()) != null) {
                this.experience.add(Integer.valueOf(readLine));
            }
            reader.close();
            Validate.isTrue((!this.experience.isEmpty() ? 1 : 0) != 0, (String)"There must be at least one exp value in your exp curve");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public ExpCurve(String id, int ... values) {
        this.id = id;
        for (int value : values) {
            this.experience.add(value);
        }
        Validate.isTrue((!this.experience.isEmpty() ? 1 : 0) != 0, (String)"There must be at least one exp value in your exp curve");
    }

    public String getId() {
        return this.id;
    }

    public int getExperience(int level) {
        Validate.isTrue((level > 0 ? 1 : 0) != 0, (String)"Level must be stricly positive");
        return this.experience.get(Math.min(level, this.experience.size()) - 1);
    }
}

