/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.waypoint;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import net.Indyuce.mmocore.waypoint.Waypoint;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockCommandTreeNode
extends CommandTreeNode {
    public LockCommandTreeNode(CommandTreeNode parent) {
        super(parent, "lock");
        this.addParameter(new Parameter("<waypoint>", (explorer, list) -> MMOCore.plugin.waypointManager.getAll().forEach(way -> list.add(way.getId()))));
        this.addParameter(Parameter.PLAYER);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        Waypoint waypoint;
        if (args.length < 4) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        if (!MMOCore.plugin.waypointManager.has(args[2])) {
            sender.sendMessage(ChatColor.RED + "Could not find waypoint " + args[2]);
            return CommandTreeNode.CommandResult.FAILURE;
        }
        Player player = Bukkit.getPlayer((String)args[3]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find player " + args[3]);
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerData playerData = PlayerData.get((OfflinePlayer)player);
        if (!playerData.hasWaypoint(waypoint = MMOCore.plugin.waypointManager.get(args[2]))) {
            sender.sendMessage(ChatColor.RED + "The waypoint " + args[2] + " is already locked.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerData.get((OfflinePlayer)player).lockWaypoint(waypoint);
        CommandVerbose.verbose(sender, CommandVerbose.CommandType.WAYPOINT, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + " successfully locked " + ChatColor.GOLD + waypoint.getId() + ChatColor.YELLOW + ".");
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

