/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.quest;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.quest.PlayerQuests;
import net.Indyuce.mmocore.api.quest.Quest;
import net.Indyuce.mmocore.command.MMOCoreCommandTreeRoot;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StartCommandTreeNode
extends CommandTreeNode {
    public StartCommandTreeNode(CommandTreeNode parent) {
        super(parent, "start");
        this.addParameter(Parameter.PLAYER);
        this.addParameter(MMOCoreCommandTreeRoot.QUEST);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        Quest quest;
        if (args.length < 4) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find player called " + args[2] + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        try {
            quest = MMOCore.plugin.questManager.get(args[3].replace("_", "-").toLowerCase());
        }
        catch (Exception exception) {
            sender.sendMessage(ChatColor.RED + "Could not find quest with ID " + args[3].replace("_", "-").toLowerCase() + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerQuests quests = PlayerData.get((OfflinePlayer)player).getQuestData();
        if (quests.hasCurrent()) {
            if (sender instanceof Player) {
                sender.sendMessage(ChatColor.RED + player.getName() + " already has an ongoing quest.");
            }
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        quests.start(quest);
        if (sender instanceof Player) {
            sender.sendMessage(ChatColor.YELLOW + player.getName() + " successfully started " + quest.getName() + ".");
        }
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

