/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.booster;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.Arrays;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.command.MMOCoreCommandTreeRoot;
import net.Indyuce.mmocore.experience.Booster;
import net.Indyuce.mmocore.experience.Profession;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;

public class CreateCommandTreeNode
extends CommandTreeNode {
    public CreateCommandTreeNode(CommandTreeNode parent) {
        super(parent, "create");
        this.addParameter(MMOCoreCommandTreeRoot.PROFESSION);
        this.addParameter(new Parameter("<extra>", (explorer, list) -> list.addAll(Arrays.asList("0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1"))));
        this.addParameter(new Parameter("<length>", (explorer, list) -> list.addAll(Arrays.asList("60", "300", "3600", "43200", "86400"))));
        this.addParameter(Parameter.PLAYER_OPTIONAL);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        long length;
        double extra;
        if (args.length < 5) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        try {
            extra = Double.parseDouble(args[3]);
        }
        catch (NumberFormatException exception) {
            sender.sendMessage(ChatColor.RED + args[3] + " is not a valid number.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        try {
            length = Long.parseLong(args[4]);
        }
        catch (NumberFormatException exception) {
            sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        if (args[2].equalsIgnoreCase("main")) {
            MMOCore.plugin.boosterManager.register(new Booster(args.length > 5 ? args[5] : null, extra, length));
            ConfigMessage.fromKey("booster-main", new Object[0]).addPlaceholders("multiplier", "" + (1.0 + extra)).send(Bukkit.getOnlinePlayers());
            Bukkit.getOnlinePlayers().forEach(player -> player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f));
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        String format = args[2].toLowerCase().replace("_", "-");
        if (!MMOCore.plugin.professionManager.has(format)) {
            sender.sendMessage(ChatColor.RED + format + " is not a valid profession.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        Profession profession = MMOCore.plugin.professionManager.get(format);
        MMOCore.plugin.boosterManager.register(new Booster(args.length > 5 ? args[5] : null, profession, extra, length));
        ConfigMessage.fromKey("booster-skill", new Object[0]).addPlaceholders("multiplier", "" + (1.0 + extra), "profession", profession.getName()).send(Bukkit.getOnlinePlayers());
        Bukkit.getOnlinePlayers().forEach(player -> player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f));
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

