/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.binding.BoundSkillInfo;
import net.Indyuce.mmocore.skill.binding.SkillSlot;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SlotCommandTreeNode
extends CommandTreeNode {
    public SlotCommandTreeNode(CommandTreeNode parent) {
        super(parent, "slot");
        this.addChild(new LockSlotCommandTreeNode(this, "lock", true));
        this.addChild(new LockSlotCommandTreeNode(this, "unlock", false));
        this.addChild(new UnbindSlotCommandTreeNode(this, "unbind"));
        this.addChild(new BindSlotCommandTreeNode(this, "bind"));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public class LockSlotCommandTreeNode
    extends CommandTreeNode {
        private final boolean lock;

        public LockSlotCommandTreeNode(CommandTreeNode parent, String id, boolean lock) {
            super(parent, id);
            this.lock = lock;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(Parameter.AMOUNT);
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int slot;
            if (args.length < 5) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)player);
            try {
                slot = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            if (slot <= 0) {
                sender.sendMessage(ChatColor.RED + "The slot can't be negative.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            SkillSlot skillSlot = playerData.getProfess().getSkillSlot(slot);
            if (skillSlot == null) {
                sender.sendMessage(ChatColor.RED + "Skill slot with index " + slot + " was not found for player " + player.getName() + " with class " + playerData.getProfess().getId());
                return CommandTreeNode.CommandResult.FAILURE;
            }
            if (skillSlot.isUnlockedByDefault()) {
                sender.sendMessage(ChatColor.RED + "You can't lock a skill that is unlocked by default.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            if (this.lock) {
                if (!playerData.hasUnlocked(skillSlot)) {
                    CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.RED + "The skill slot " + skillSlot.getName() + " is already locked for " + player.getName());
                    return CommandTreeNode.CommandResult.SUCCESS;
                }
                playerData.lock(skillSlot);
            } else {
                if (playerData.hasUnlocked(skillSlot)) {
                    CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.RED + "The skill slot " + skillSlot.getName() + " is already unlocked for " + player.getName());
                    return CommandTreeNode.CommandResult.SUCCESS;
                }
                playerData.unlock(skillSlot);
            }
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.YELLOW + "The skill slot " + skillSlot.getName() + " is now " + (this.lock ? "locked" : "unlocked for " + player.getName()));
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }

    public class UnbindSlotCommandTreeNode
    extends CommandTreeNode {
        public UnbindSlotCommandTreeNode(CommandTreeNode parent, String id) {
            super(parent, id);
            this.addParameter(Parameter.PLAYER);
            this.addParameter(Parameter.AMOUNT);
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int slot;
            if (args.length < 5) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)player);
            try {
                slot = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            BoundSkillInfo found = playerData.unbindSkill(slot);
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.YELLOW + (found != null ? "Skill " + ChatColor.GOLD + found.getClassSkill().getSkill().getName() + ChatColor.YELLOW + " was taken off the slot " + ChatColor.GOLD + slot : "Could not find skill at slot " + ChatColor.GOLD + slot));
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }

    public class BindSlotCommandTreeNode
    extends CommandTreeNode {
        public BindSlotCommandTreeNode(CommandTreeNode parent, String id) {
            super(parent, id);
            this.addParameter(Parameter.PLAYER);
            this.addParameter(Parameter.AMOUNT);
            this.addParameter(new Parameter("<skill>", (explorer, list) -> MMOCore.plugin.skillManager.getAll().forEach(skill -> list.add(skill.getHandler().getId().toUpperCase()))));
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int slot;
            if (args.length < 6) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)player);
            try {
                slot = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            ClassSkill skill = playerData.getProfess().getSkill(args[5]);
            if (skill == null) {
                sender.sendMessage(ChatColor.RED + "The player's class doesn't have a skill called  " + args[5] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            playerData.bindSkill(slot, skill);
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.YELLOW + "Skill " + ChatColor.GOLD + skill.getSkill().getHandler().getId() + ChatColor.YELLOW + " now bound to slot " + ChatColor.GOLD + slot);
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }
}

