/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.function.BiFunction;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.RegisteredSkill;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillCommandTreeNode
extends CommandTreeNode {
    public SkillCommandTreeNode(CommandTreeNode parent) {
        super(parent, "skill");
        this.addChild(new LockSkillCommandTreeNode(this, "lock", true));
        this.addChild(new LockSkillCommandTreeNode(this, "unlock", false));
        this.addChild(new LevelCommandTreeNode(this, "give", (old, amount) -> old + amount));
        this.addChild(new LevelCommandTreeNode(this, "set", (old, amount) -> amount));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public class LockSkillCommandTreeNode
    extends CommandTreeNode {
        private final boolean lock;

        public LockSkillCommandTreeNode(CommandTreeNode parent, String id, boolean lock) {
            super(parent, id);
            this.lock = lock;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(new Parameter("<skill>", (explorer, list) -> MMOCore.plugin.skillManager.getAll().forEach(skill -> list.add(skill.getHandler().getId().toUpperCase()))));
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            if (args.length < 5) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)player);
            ClassSkill skill = playerData.getProfess().getSkill(args[4]);
            if (skill == null) {
                sender.sendMessage(ChatColor.RED + "Class doesn't have a skill called  " + args[4] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            if (this.lock) {
                if (!playerData.hasUnlocked(skill)) {
                    CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.RED + "Skill " + skill.getSkill().getName() + " already locked for " + player.getName());
                    return CommandTreeNode.CommandResult.SUCCESS;
                }
                playerData.lock(skill);
            } else {
                if (playerData.hasUnlocked(skill)) {
                    CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.RED + "Skill " + skill.getSkill().getName() + " already unlocked for " + player.getName());
                    return CommandTreeNode.CommandResult.SUCCESS;
                }
                playerData.unlock(skill);
            }
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.YELLOW + "Skill " + ChatColor.GOLD + skill.getSkill().getName() + ChatColor.YELLOW + " now " + (this.lock ? "locked" : "unlocked") + " for " + ChatColor.GOLD + player.getName());
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }

    public class LevelCommandTreeNode
    extends CommandTreeNode {
        private final BiFunction<Integer, Integer, Integer> change;

        public LevelCommandTreeNode(CommandTreeNode parent, String type, BiFunction<Integer, Integer, Integer> change) {
            super(parent, type);
            this.change = change;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(new Parameter("<skill>", (explorer, list) -> MMOCore.plugin.skillManager.getAll().forEach(skill -> list.add(skill.getHandler().getId().toUpperCase()))));
            this.addParameter(Parameter.AMOUNT);
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int amount;
            if (args.length < 6) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)player);
            RegisteredSkill skill = MMOCore.plugin.skillManager.getSkill(args[4]);
            if (skill == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the skill called " + args[4] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            ClassSkill classSkill = null;
            for (ClassSkill var : playerData.getProfess().getSkills()) {
                if (!var.getSkill().equals(skill)) continue;
                classSkill = var;
            }
            if (classSkill == null || classSkill.getUnlockLevel() > playerData.getLevel()) {
                sender.sendMessage(ChatColor.RED + skill.getName() + " is not unlockable for " + player.getName() + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            try {
                amount = Integer.parseInt(args[5]);
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + args[5] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            int value = this.change.apply(playerData.getSkillLevel(skill), amount);
            playerData.setSkillLevel(skill, value);
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL, ChatColor.YELLOW + player.getName() + ChatColor.YELLOW + " is now level  " + ChatColor.GOLD + value + ChatColor.YELLOW + " for " + skill.getName() + ".");
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }
}

