/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PointsCommandTreeNode
extends CommandTreeNode {
    private final String type;
    private final Function<PlayerData, Integer> get;

    public PointsCommandTreeNode(String type, CommandTreeNode parent, BiConsumer<PlayerData, Integer> set, BiConsumer<PlayerData, Integer> give, Function<PlayerData, Integer> get) {
        super(parent, type + "-points");
        this.type = type;
        this.get = get;
        this.addChild(new ActionCommandTreeNode(this, "set", set));
        this.addChild(new ActionCommandTreeNode(this, "give", give));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public class ActionCommandTreeNode
    extends CommandTreeNode {
        private final BiConsumer<PlayerData, Integer> action;

        public ActionCommandTreeNode(CommandTreeNode parent, String type, BiConsumer<PlayerData, Integer> action) {
            super(parent, type);
            this.action = action;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(Parameter.AMOUNT);
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int amount;
            if (args.length < 5) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            try {
                amount = Integer.parseInt(args[4]);
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData data = PlayerData.get((OfflinePlayer)player);
            this.action.accept(data, amount);
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.POINTS, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + " now has " + ChatColor.GOLD + PointsCommandTreeNode.this.get.apply(data) + ChatColor.YELLOW + " " + PointsCommandTreeNode.this.type + " points.");
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }
}

