/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttribute;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttributes;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AttributeCommandTreeNode
extends CommandTreeNode {
    public AttributeCommandTreeNode(CommandTreeNode parent) {
        super(parent, "attribute");
        this.addChild(new ActionCommandTreeNode(this, "give", false));
        this.addChild(new ActionCommandTreeNode(this, "take", true));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public class ActionCommandTreeNode
    extends CommandTreeNode {
        private final int c;

        public ActionCommandTreeNode(CommandTreeNode parent, String type, boolean take) {
            super(parent, type);
            this.c = take ? -1 : 1;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(new Parameter("<attribute>", (explorer, list) -> MMOCore.plugin.attributeManager.getAll().forEach(attribute -> list.add(attribute.getId()))));
            this.addParameter(Parameter.AMOUNT);
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int amount;
            if (args.length < 6) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            String format = args[4].toLowerCase().replace("_", "-");
            if (!MMOCore.plugin.attributeManager.has(format)) {
                sender.sendMessage(ChatColor.RED + "Could not find the attribute called " + args[4] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerAttribute attribute = MMOCore.plugin.attributeManager.get(format);
            try {
                amount = Integer.parseInt(args[5]);
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + args[5] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerAttributes.AttributeInstance instance = PlayerData.get((OfflinePlayer)player).getAttributes().getInstance(attribute);
            instance.setBase(Math.min(attribute.getMax(), instance.getBase() + this.c * amount));
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.ATTRIBUTE, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + " now has " + ChatColor.GOLD + instance.getBase() + ChatColor.YELLOW + " " + attribute.getName() + ".");
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }
}

