/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.api;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigFile;
import net.Indyuce.mmocore.command.AttributesCommand;
import net.Indyuce.mmocore.command.ClassCommand;
import net.Indyuce.mmocore.command.DepositCommand;
import net.Indyuce.mmocore.command.FriendsCommand;
import net.Indyuce.mmocore.command.GuildCommand;
import net.Indyuce.mmocore.command.PartyCommand;
import net.Indyuce.mmocore.command.PlayerStatsCommand;
import net.Indyuce.mmocore.command.PvpModeCommand;
import net.Indyuce.mmocore.command.QuestsCommand;
import net.Indyuce.mmocore.command.SkillTreesCommand;
import net.Indyuce.mmocore.command.SkillsCommand;
import net.Indyuce.mmocore.command.WaypointsCommand;
import net.Indyuce.mmocore.command.WithdrawCommand;
import net.Indyuce.mmocore.command.api.RegisteredCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ToggleableCommand {
    PLAYER("player", "Displays player stats", config -> new PlayerStatsCommand((ConfigurationSection)config), "p", "profile"),
    ATTRIBUTES("attributes", "Display and manage attributes", config -> new AttributesCommand((ConfigurationSection)config), "att", "stats"),
    CLASS("class", "Select a new class", config -> new ClassCommand((ConfigurationSection)config), "c"),
    WAYPOINTS("waypoints", "Display discovered waypoints", config -> new WaypointsCommand((ConfigurationSection)config), "wp"),
    QUESTS("quests", "Display available quests", config -> new QuestsCommand((ConfigurationSection)config), "q", "journal"),
    SKILLS("skills", "Spend skill points to unlock new skills", config -> new SkillsCommand((ConfigurationSection)config), "s"),
    FRIENDS("friends", "Show online/offline friends", config -> new FriendsCommand((ConfigurationSection)config), "f"),
    PARTY("party", "Invite players in a party to split exp", config -> new PartyCommand((ConfigurationSection)config), new String[0]),
    GUILD("guild", "Show players in current guild", config -> new GuildCommand((ConfigurationSection)config), new String[0]),
    WITHDRAW("withdraw", "Withdraw money into coins and notes", config -> new WithdrawCommand((ConfigurationSection)config), v -> MMOCore.plugin.hasEconomy() && MMOCore.plugin.economy.isValid(), "w"),
    SKILL_TREES("skilltrees", "Open up the skill tree menu", config -> new SkillTreesCommand((ConfigurationSection)config), "st", "trees", "tree"),
    DEPOSIT("deposit", "Open the currency deposit menu", config -> new DepositCommand((ConfigurationSection)config), "d"),
    PVP_MODE("pvpmode", "Toggle on/off PVP mode.", config -> new PvpModeCommand((ConfigurationSection)config), "pvp");

    private final String mainLabel;
    private final String description;
    private final Function<ConfigurationSection, RegisteredCommand> generator;
    private final List<String> aliases;
    private final Predicate<Void> enabled;

    private ToggleableCommand(@NotNull String mainLabel, @NotNull String description, Function<ConfigurationSection, RegisteredCommand> generator, String ... aliases) {
        this(mainLabel, description, generator, (Predicate<Void>)null, aliases);
    }

    private ToggleableCommand(@NotNull String mainLabel, @Nullable String description, @NotNull Function<ConfigurationSection, RegisteredCommand> generator, Predicate<Void> enabled, String ... aliases) {
        this.mainLabel = mainLabel;
        this.description = description;
        this.generator = generator;
        this.aliases = Arrays.asList(aliases);
        this.enabled = enabled == null ? v -> true : enabled;
    }

    public String getMainLabel() {
        return this.mainLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getConfigPath() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public boolean isEnabled() {
        return this.enabled.test(null);
    }

    public static void register() {
        if (!new File(MMOCore.plugin.getDataFolder(), "commands.yml").exists()) {
            ConfigFile config = new ConfigFile("commands");
            for (ToggleableCommand cmd : ToggleableCommand.values()) {
                String path = cmd.getConfigPath();
                config.getConfig().set(path + ".main", (Object)cmd.mainLabel);
                config.getConfig().set(path + ".aliases", cmd.aliases);
                config.getConfig().set(path + ".description", (Object)cmd.description);
            }
            config.save();
        }
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            FileConfiguration config = new ConfigFile("commands").getConfig();
            for (ToggleableCommand cmd : ToggleableCommand.values()) {
                if (!cmd.isEnabled() || !config.contains(cmd.getConfigPath())) continue;
                commandMap.register("mmocore", (Command)cmd.generator.apply(config.getConfigurationSection(cmd.getConfigPath())));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            MMOCore.plugin.getLogger().log(Level.WARNING, "Unable to register custom commands:");
            exception.printStackTrace();
        }
    }
}

