/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.api;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CommandVerbose {
    private final Map<CommandType, VerboseValue> values = new HashMap<CommandType, VerboseValue>();

    public void reload(ConfigurationSection config) {
        this.values.clear();
        for (CommandType type : CommandType.values()) {
            try {
                this.values.put(type, VerboseValue.valueOf(config.getString(UtilityMethods.ymlName((String)type.name()), "TRUE").toUpperCase()));
            }
            catch (IllegalArgumentException exception) {
                this.values.put(type, VerboseValue.TRUE);
                MMOCore.plugin.getLogger().log(Level.WARNING, "Could not load command verbose action for " + type.name());
            }
        }
    }

    public void handle(CommandSender sender, CommandType type, String verbose) {
        switch (this.values.getOrDefault((Object)type, VerboseValue.FALSE).ordinal()) {
            case 3: {
                return;
            }
            case 0: {
                sender.sendMessage(verbose);
                break;
            }
            case 1: {
                if (!(sender instanceof Player)) break;
                sender.sendMessage(verbose);
                break;
            }
            case 2: {
                if (!(sender instanceof ConsoleCommandSender)) break;
                sender.sendMessage(verbose);
            }
        }
    }

    public static void verbose(CommandSender sender, CommandType cmd, String verbose) {
        MMOCore.plugin.configManager.commandVerbose.handle(sender, cmd, verbose);
    }

    public static enum CommandType {
        ATTRIBUTE,
        SKILL,
        CLASS,
        EXPERIENCE,
        LEVEL,
        NOCD,
        POINTS,
        SKILL_TREE_POINTS,
        RESET,
        RESOURCE,
        WAYPOINT;

    }

    private static enum VerboseValue {
        TRUE,
        PLAYER,
        CONSOLE,
        FALSE;

    }
}

