/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command;

import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.event.MMOCommandEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.social.Request;
import net.Indyuce.mmocore.command.api.RegisteredCommand;
import net.Indyuce.mmocore.command.api.ToggleableCommand;
import net.Indyuce.mmocore.manager.InventoryManager;
import net.Indyuce.mmocore.party.provided.MMOCorePartyModule;
import net.Indyuce.mmocore.party.provided.PartyInvite;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyCommand
extends RegisteredCommand {
    public PartyCommand(ConfigurationSection config) {
        super(config, ToggleableCommand.PARTY);
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (!sender.hasPermission("mmocore.party")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command is for players only.");
            return true;
        }
        if (!(MMOCore.plugin.partyModule instanceof MMOCorePartyModule)) {
            sender.sendMessage(ChatColor.RED + "You can't use MMOCore party system as you delegated the party system to another plugin.");
            return true;
        }
        PlayerData data = PlayerData.get((OfflinePlayer)sender);
        MMOCommandEvent event = new MMOCommandEvent(data, "party");
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        if (args.length > 0) {
            PartyInvite invite;
            if (args.length > 1) {
                try {
                    Request req = MMOCore.plugin.requestManager.getRequest(UUID.fromString(args[1]));
                    Validate.isTrue((req instanceof PartyInvite && !req.isTimedOut() ? 1 : 0) != 0);
                    invite = (PartyInvite)req;
                    Validate.isTrue((boolean)((MMOCorePartyModule)MMOCore.plugin.partyModule).isRegistered(invite.getParty()));
                }
                catch (Exception exception) {
                    return true;
                }
            } else {
                invite = MMOCore.plugin.requestManager.findRequest(data, PartyInvite.class);
            }
            if (invite == null) {
                return true;
            }
            if (args[0].equalsIgnoreCase("accept")) {
                invite.accept();
            } else if (args[0].equalsIgnoreCase("deny")) {
                invite.deny();
            }
            return true;
        }
        if (data.getParty() != null) {
            InventoryManager.PARTY_VIEW.newInventory(data).open();
        } else {
            InventoryManager.PARTY_CREATION.newInventory(data).open();
        }
        return true;
    }
}

