/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.api.quest.trigger;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.quest.trigger.Trigger;
import net.Indyuce.mmocore.api.quest.trigger.api.Removable;
import org.apache.commons.lang.Validate;

public class UnlockSlotTrigger
extends Trigger
implements Removable {
    private final int slot;

    public UnlockSlotTrigger(MMOLineConfig config) {
        super(config);
        config.validateKeys(new String[]{"slot"});
        try {
            this.slot = Integer.parseInt(config.getString("slot"));
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Slot should be a number");
        }
        Validate.isTrue((this.slot > 0 ? 1 : 0) != 0, (String)"Slot number must be positive");
    }

    @Override
    public void apply(PlayerData player) {
        player.unlock(player.getProfess().getSkillSlot(this.slot));
    }

    @Override
    public void remove(PlayerData player) {
        player.lock(player.getProfess().getSkillSlot(this.slot));
    }
}

