/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.api.player.stats;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import io.lumine.mythic.lib.player.modifier.PlayerModifier;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.player.skill.PassiveSkillMap;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.stats.StatType;
import net.Indyuce.mmocore.experience.Profession;
import net.Indyuce.mmocore.player.stats.StatInfo;
import net.Indyuce.mmocore.skill.ClassSkill;

public class PlayerStats {
    private final PlayerData data;

    public PlayerStats(PlayerData data) {
        this.data = data;
    }

    public PlayerData getData() {
        return this.data;
    }

    public StatMap getMap() {
        return this.data.getMMOPlayerData().getStatMap();
    }

    @Deprecated
    public StatInstance getInstance(StatType stat) {
        return this.getMap().getInstance(stat.name());
    }

    @Deprecated
    public StatInstance getInstance(String stat) {
        return this.getMap().getInstance(stat);
    }

    public double getStat(String stat) {
        return this.getMap().getStat(stat);
    }

    public double getBase(String stat) {
        Profession profession = StatInfo.valueOf((String)stat).profession;
        return this.data.getProfess().calculateStat(stat, profession == null ? this.data.getLevel() : this.data.getCollectionSkills().getLevel(profession));
    }

    public void updateStats() {
        this.updateStats(false);
    }

    public synchronized void updateStats(boolean castLoginScripts) {
        for (String stat : MMOCore.plugin.statManager.getRegistered()) {
            StatInstance statInstance = this.getMap().getInstance(stat);
            StatInstance.ModifierPacket packet = statInstance.newPacket();
            packet.remove("mmocoreClass");
            double total = this.getBase(statInstance.getStat()) - statInstance.getBase();
            if (total != 0.0) {
                packet.addModifier(new StatModifier("mmocoreClass", statInstance.getStat(), total, ModifierType.FLAT, EquipmentSlot.OTHER, ModifierSource.OTHER));
            }
            packet.runUpdate();
        }
        PassiveSkillMap skillMap = this.data.getMMOPlayerData().getPassiveSkillMap();
        skillMap.removeModifiers("MMOCorePermanentSkill");
        for (ClassSkill classSkill : this.data.getProfess().getSkills()) {
            if (!classSkill.isPermanent() || classSkill.getSkill().getTrigger() == TriggerType.LOGIN || !this.data.hasUnlocked(classSkill) || !this.data.hasUnlockedLevel(classSkill)) continue;
            skillMap.addModifier((PlayerModifier)classSkill.toPassive(this.data));
        }
        skillMap.removeModifiers("MMOCoreClassScript");
        for (PassiveSkill passiveSkill : this.data.getProfess().getScripts()) {
            if (passiveSkill.getType() == TriggerType.LOGIN) continue;
            skillMap.addModifier((PlayerModifier)passiveSkill);
        }
        if (castLoginScripts) {
            for (ClassSkill classSkill : this.data.getProfess().getSkills()) {
                if (classSkill.getSkill().getTrigger() != TriggerType.LOGIN) continue;
                classSkill.toCastable(this.data).cast(this.data.getMMOPlayerData());
            }
            for (PassiveSkill passiveSkill : this.data.getProfess().getScripts()) {
                if (passiveSkill.getType() != TriggerType.LOGIN) continue;
                passiveSkill.getTriggeredSkill().cast(this.data.getMMOPlayerData());
            }
        }
    }
}

