/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.api.eco;

import io.lumine.mythic.lib.api.util.SmartGive;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.util.item.CurrencyItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Withdraw
implements Listener {
    private static final Set<UUID> withdrawing = new HashSet<UUID>();
    private final Player player;

    public Withdraw(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void open() {
        if (this.isWithdrawing()) {
            return;
        }
        withdrawing.add(this.player.getUniqueId());
        ConfigMessage.fromKey("withdrawing", new Object[0]).send(this.player);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MMOCore.plugin);
        Bukkit.getScheduler().runTaskLater((Plugin)MMOCore.plugin, this::close, 400L);
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
        withdrawing.remove(this.player.getUniqueId());
    }

    public boolean isWithdrawing() {
        return withdrawing.contains(this.player.getUniqueId());
    }

    @EventHandler
    public void a(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        if (!event.getPlayer().equals((Object)this.player)) {
            return;
        }
        ConfigMessage.fromKey("withdraw-cancel", new Object[0]).send(this.player);
        this.close();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void b(AsyncPlayerChatEvent event) {
        int worth;
        if (!event.getPlayer().equals((Object)this.player)) {
            return;
        }
        event.setCancelled(true);
        try {
            worth = Integer.parseInt(event.getMessage());
        }
        catch (Exception e) {
            ConfigMessage.fromKey("wrong-number", new Object[0]).addPlaceholders("arg", event.getMessage()).send(this.player);
            return;
        }
        int left = (int)(MMOCore.plugin.economy.getEconomy().getBalance((OfflinePlayer)this.player) - (double)worth);
        if (left < 0) {
            ConfigMessage.fromKey("not-enough-money", new Object[0]).addPlaceholders("left", -left).send(this.player);
            return;
        }
        this.close();
        Bukkit.getScheduler().runTask((Plugin)MMOCore.plugin, () -> {
            MMOCore.plugin.economy.getEconomy().withdrawPlayer((OfflinePlayer)this.player, (double)worth);
            this.withdrawAlgorithm(worth);
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            ConfigMessage.fromKey("withdrew", new Object[0]).addPlaceholders("worth", worth).send(this.player);
        });
    }

    @Deprecated
    public void withdrawAlgorythm(int worth) {
        this.withdrawAlgorithm(worth);
    }

    public void withdrawAlgorithm(int worth) {
        int note = worth / 10 * 10;
        int coins = worth - note;
        SmartGive smart = new SmartGive(this.player);
        if (note > 0) {
            smart.give(new ItemStack[]{new CurrencyItemBuilder("NOTE", note).build()});
        }
        ItemStack coinsItem = new CurrencyItemBuilder("GOLD_COIN", 1).build();
        coinsItem.setAmount(coins);
        smart.give(new ItemStack[]{coinsItem});
    }

    @EventHandler
    public void c(PlayerQuitEvent event) {
        if (event.getPlayer().equals((Object)this.player)) {
            this.close();
        }
    }
}

