/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.api;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import java.util.Objects;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.party.AbstractParty;
import net.Indyuce.mmocore.skill.CastableSkill;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.RegisteredSkill;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MMOCoreAPI {
    private final JavaPlugin plugin;

    public MMOCoreAPI(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public PlayerData getPlayerData(OfflinePlayer player) {
        return PlayerData.get(player);
    }

    public boolean isInSameParty(Player player1, Player player2) {
        AbstractParty party = MMOCore.plugin.partyModule.getParty(PlayerData.get((OfflinePlayer)player1));
        return party != null && party.hasMember(player2);
    }

    public SkillResult cast(PlayerData playerData, String skillId, int level) {
        return this.cast(playerData, MMOCore.plugin.skillManager.getSkillOrThrow(skillId), level);
    }

    public SkillResult cast(PlayerData playerData, ClassSkill skill) {
        PlayerMetadata casterMeta = playerData.getMMOPlayerData().getStatMap().cache(EquipmentSlot.MAIN_HAND);
        TriggerMetadata triggerMeta = new TriggerMetadata(casterMeta, null, null);
        return new CastableSkill(skill, playerData).cast(triggerMeta);
    }

    public SkillResult cast(PlayerData playerData, RegisteredSkill skill, int level) {
        PlayerMetadata casterMeta = playerData.getMMOPlayerData().getStatMap().cache(EquipmentSlot.MAIN_HAND);
        TriggerMetadata triggerMeta = new TriggerMetadata(casterMeta, null, null);
        return new CastableSkill(new ClassSkill(skill, 0, 0), level).cast(triggerMeta);
    }

    public SkillResult cast(PlayerData playerData, SkillHandler<?> skill, int level) {
        PlayerMetadata casterMeta = playerData.getMMOPlayerData().getStatMap().cache(EquipmentSlot.MAIN_HAND);
        TriggerMetadata triggerMeta = new TriggerMetadata(casterMeta, null, null);
        RegisteredSkill registered = Objects.requireNonNull(MMOCore.plugin.skillManager.getSkill(skill.getId()), "Could not find registered skill with such handler");
        return new CastableSkill(new ClassSkill(registered, 0, 0), level).cast(triggerMeta);
    }
}

