package me.domi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySQL {

    private Connection connection;

    private final String host;
    private final String port;
    private final String database;
    private final String username;
    private final String password;

    public MySQL(String host, String port, String database, String username, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    public boolean isConnected() {
        return connection != null;
    }

    public void connect() {
        if (isConnected()) {
            System.err.println("Database already connected!");
            return;
        }

        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        try {
            connection = DriverManager.getConnection(url, username, password);
            System.out.println("Database connected!");
        } catch (SQLException e) {
            System.err.println("Error(C): " + e.getMessage());
        }
    }

    public void disconnect() {
        if (!isConnected()) {
            System.err.println("Database not connected!");
            return;
        }

        try {
            connection.close();
            connection = null;
            System.out.println("Database disconnected!");
        } catch (SQLException e) {
            System.err.println("Error(D): " + e.getMessage());
        }
    }

    private Connection reconnect() {
        try {
            return DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password);
        } catch (SQLException e) {
            System.err.println("Error(R): " + e.getMessage());
        }
        return null;
    }

    public Connection getConnection() {
        try {
            if (connection.isClosed()) {
                connection = reconnect();
                System.out.println("Database reconnected!");
            }
        } catch (SQLException e) {
            System.err.println("Error(GC): " + e.getMessage());
        }
        return connection;
    }

    public void createTable() {
        if (!isConnected()) {
            System.err.println("Database not connected!");
            return;
        }

        try {
            PreparedStatement preparedStatement = getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS data (name VARCHAR(255), message TINYTEXT)");
            preparedStatement.executeUpdate();
            System.out.println("Table created!");
        } catch (SQLException e) {
            System.err.println("Error(CT): " + e.getMessage());
        }
    }

    public void addMessage(String name, String message) {
        if (!isConnected()) {
            System.err.println("Database not connected!");
            return;
        }

        try {
            PreparedStatement preparedStatement = getConnection().prepareStatement("INSERT INTO data (name, message) VALUES (?, ?)");
            preparedStatement.setString(1, name);
            preparedStatement.setString(2, message);
            preparedStatement.executeUpdate();
        } catch (SQLException e) {
            System.err.println("Error(AM): " + e.getMessage());
        }
    }

}
